/*
 * Decompiled with CFR 0.152.
 */
package optifine.xdelta;

import optifine.xdelta.BitArray;

public class EratosthenesPrimes {
    static BitArray sieve;
    static int lastInit;

    public static synchronized void reset() {
        sieve = null;
        lastInit = -1;
    }

    public static synchronized void init(int maxNumber) {
        if (maxNumber > lastInit) {
            int i2 = (int)Math.ceil(Math.sqrt(maxNumber));
            lastInit = maxNumber;
            maxNumber >>= 1;
            i2 >>= 1;
            ++i2;
            sieve = new BitArray(++maxNumber + 1);
            sieve.set(0, true);
            for (int j2 = 1; j2 <= i2; ++j2) {
                if (sieve.get(j2)) continue;
                int k2 = (j2 << 1) + 1;
                for (int l2 = j2 * ((j2 << 1) + 2); l2 <= maxNumber; l2 += k2) {
                    sieve.set(l2, true);
                }
            }
        }
    }

    public static synchronized int[] getPrimes(int maxNumber) {
        int i2 = EratosthenesPrimes.primesCount(maxNumber);
        if (i2 <= 0) {
            return new int[0];
        }
        if (maxNumber == 2) {
            return new int[]{2};
        }
        EratosthenesPrimes.init(maxNumber);
        int[] aint = new int[i2];
        int j2 = maxNumber - 1 >> 1;
        int k2 = 0;
        aint[k2++] = 2;
        for (int l2 = 1; l2 <= j2; ++l2) {
            if (sieve.get(l2)) continue;
            aint[k2++] = (l2 << 1) + 1;
        }
        return aint;
    }

    public static synchronized int primesCount(int number) {
        if (number < 2) {
            return 0;
        }
        EratosthenesPrimes.init(number);
        int i2 = number - 1 >> 1;
        int j2 = 1;
        for (int k2 = 1; k2 <= i2; ++k2) {
            if (sieve.get(k2)) continue;
            ++j2;
        }
        return j2;
    }

    public static synchronized int belowOrEqual(int number) {
        int i2;
        if (number < 2) {
            return -1;
        }
        if (number == 2) {
            return 2;
        }
        EratosthenesPrimes.init(number);
        for (int j2 = i2 = number - 1 >> 1; j2 > 0; --j2) {
            if (sieve.get(j2)) continue;
            return (j2 << 1) + 1;
        }
        return -1;
    }

    public static int below(int number) {
        return EratosthenesPrimes.belowOrEqual(number - 1);
    }

    static {
        lastInit = -1;
    }
}

