/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import io.netty.util.internal.deque.ArrayDequeV6;
import java.lang.reflect.Array;

public class CacheObjectArray {
    private static final ArrayDequeV6<int[]> arrays = new ArrayDequeV6();
    private static int maxCacheSize = 10;

    private static synchronized int[] allocateArray(int size) {
        int[] aint = (int[])arrays.pollLast();
        if (aint == null || aint.length < size) {
            aint = new int[size];
        }
        return aint;
    }

    public static synchronized void freeArray(int[] ints) {
        if (arrays.size() < maxCacheSize) {
            arrays.add((Object)ints);
        }
    }

    public static void main(String[] args) throws Exception {
        int i2 = 4096;
        int j2 = 500000;
        CacheObjectArray.testNew(i2, j2);
        CacheObjectArray.testClone(i2, j2);
        CacheObjectArray.testNewObj(i2, j2);
        CacheObjectArray.testCloneObj(i2, j2);
        CacheObjectArray.testNewObjDyn(alz.class, i2, j2);
        long k2 = CacheObjectArray.testNew(i2, j2);
        long l2 = CacheObjectArray.testClone(i2, j2);
        long i1 = CacheObjectArray.testNewObj(i2, j2);
        long j1 = CacheObjectArray.testCloneObj(i2, j2);
        long k1 = CacheObjectArray.testNewObjDyn(alz.class, i2, j2);
        Config.dbg("New: " + k2);
        Config.dbg("Clone: " + l2);
        Config.dbg("NewObj: " + i1);
        Config.dbg("CloneObj: " + j1);
        Config.dbg("NewObjDyn: " + k1);
    }

    private static long testClone(int size, int count) {
        long i2 = System.currentTimeMillis();
        int[] aint = new int[size];
        for (int j2 = 0; j2 < count; ++j2) {
            int[] nArray = (int[])aint.clone();
        }
        long k2 = System.currentTimeMillis();
        return k2 - i2;
    }

    private static long testNew(int size, int count) {
        long i2 = System.currentTimeMillis();
        for (int j2 = 0; j2 < count; ++j2) {
            int[] nArray = (int[])Array.newInstance(Integer.TYPE, size);
        }
        long k2 = System.currentTimeMillis();
        return k2 - i2;
    }

    private static long testCloneObj(int size, int count) {
        long i2 = System.currentTimeMillis();
        alz[] aiblockstate = new alz[size];
        for (int j2 = 0; j2 < count; ++j2) {
            alz[] alzArray = (alz[])aiblockstate.clone();
        }
        long k2 = System.currentTimeMillis();
        return k2 - i2;
    }

    private static long testNewObj(int size, int count) {
        long i2 = System.currentTimeMillis();
        for (int j2 = 0; j2 < count; ++j2) {
            alz[] alzArray = new alz[size];
        }
        long k2 = System.currentTimeMillis();
        return k2 - i2;
    }

    private static long testNewObjDyn(Class cls, int size, int count) {
        long i2 = System.currentTimeMillis();
        for (int j2 = 0; j2 < count; ++j2) {
            Object[] objectArray = (Object[])Array.newInstance(cls, size);
        }
        long k2 = System.currentTimeMillis();
        return k2 - i2;
    }
}

