/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.ArrayList;
import java.util.Properties;
import net.optifine.IRandomEntity;
import net.optifine.RandomEntityRule;
import net.optifine.config.ConnectedParser;

public class RandomEntityProperties {
    public String name = null;
    public String basePath = null;
    public jy[] resourceLocations = null;
    public RandomEntityRule[] rules = null;

    public RandomEntityProperties(String path, jy[] variants) {
        ConnectedParser connectedparser = new ConnectedParser("RandomEntities");
        this.name = connectedparser.parseName(path);
        this.basePath = connectedparser.parseBasePath(path);
        this.resourceLocations = variants;
    }

    public RandomEntityProperties(Properties props, String path, jy baseResLoc) {
        ConnectedParser connectedparser = new ConnectedParser("RandomEntities");
        this.name = connectedparser.parseName(path);
        this.basePath = connectedparser.parseBasePath(path);
        this.rules = this.parseRules(props, path, baseResLoc, connectedparser);
    }

    public jy getTextureLocation(jy loc, IRandomEntity randomEntity) {
        if (this.rules != null) {
            for (int i2 = 0; i2 < this.rules.length; ++i2) {
                RandomEntityRule randomentityrule = this.rules[i2];
                if (!randomentityrule.matches(randomEntity)) continue;
                return randomentityrule.getTextureLocation(loc, randomEntity.getId());
            }
        }
        if (this.resourceLocations != null) {
            int j2 = randomEntity.getId();
            int k2 = j2 % this.resourceLocations.length;
            return this.resourceLocations[k2];
        }
        return loc;
    }

    private RandomEntityRule[] parseRules(Properties props, String pathProps, jy baseResLoc, ConnectedParser cp2) {
        ArrayList<RandomEntityRule> list = new ArrayList<RandomEntityRule>();
        int i2 = props.size();
        for (int j2 = 0; j2 < i2; ++j2) {
            RandomEntityRule randomentityrule;
            int k2 = j2 + 1;
            String s2 = props.getProperty("textures." + k2);
            if (s2 == null) {
                s2 = props.getProperty("skins." + k2);
            }
            if (s2 == null || !(randomentityrule = new RandomEntityRule(props, pathProps, baseResLoc, k2, s2, cp2)).isValid(pathProps)) continue;
            list.add(randomentityrule);
        }
        RandomEntityRule[] arandomentityrule = list.toArray(new RandomEntityRule[list.size()]);
        return arandomentityrule;
    }

    public boolean isValid(String path) {
        if (this.resourceLocations == null && this.rules == null) {
            Config.warn("No skins specified: " + path);
            return false;
        }
        if (this.rules != null) {
            for (int i2 = 0; i2 < this.rules.length; ++i2) {
                RandomEntityRule randomentityrule = this.rules[i2];
                if (randomentityrule.isValid(path)) continue;
                return false;
            }
        }
        if (this.resourceLocations != null) {
            for (int j2 = 0; j2 < this.resourceLocations.length; ++j2) {
                jy resourcelocation = this.resourceLocations[j2];
                if (Config.hasResource(resourcelocation)) continue;
                Config.warn("Texture not found: " + resourcelocation.a());
                return false;
            }
        }
        return true;
    }

    public boolean isDefault() {
        return this.rules != null ? false : this.resourceLocations == null;
    }
}

