/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.optifine.DynamicLight;
import net.optifine.DynamicLightsMap;
import net.optifine.config.ConnectedParser;
import net.optifine.config.EntityClassLocator;
import net.optifine.config.IObjectLocator;
import net.optifine.config.ItemLocator;
import net.optifine.reflect.ReflectorForge;
import net.optifine.util.PropertiesOrdered;

public class DynamicLights {
    private static DynamicLightsMap mapDynamicLights = new DynamicLightsMap();
    private static Map<Class, Integer> mapEntityLightLevels = new HashMap<Class, Integer>();
    private static Map<zw, Integer> mapItemLightLevels = new HashMap<zw, Integer>();
    private static long timeUpdateMs = 0L;
    private static final double MAX_DIST = 7.5;
    private static final double MAX_DIST_SQ = 56.25;
    private static final int LIGHT_LEVEL_MAX = 15;
    private static final int LIGHT_LEVEL_FIRE = 15;
    private static final int LIGHT_LEVEL_BLAZE = 10;
    private static final int LIGHT_LEVEL_MAGMA_CUBE = 8;
    private static final int LIGHT_LEVEL_MAGMA_CUBE_CORE = 13;
    private static final int LIGHT_LEVEL_GLOWSTONE_DUST = 8;
    private static final int LIGHT_LEVEL_PRISMARINE_CRYSTALS = 8;
    private static boolean initialized;

    public static void entityAdded(pk entityIn, bfr renderGlobal) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void entityRemoved(pk entityIn, bfr renderGlobal) {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            DynamicLight dynamiclight = mapDynamicLights.remove(entityIn.F());
            if (dynamiclight != null) {
                dynamiclight.updateLitChunks(renderGlobal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(bfr renderGlobal) {
        long i2 = System.currentTimeMillis();
        if (i2 >= timeUpdateMs + 50L) {
            timeUpdateMs = i2;
            if (!initialized) {
                DynamicLights.initialize();
            }
            DynamicLightsMap dynamicLightsMap = mapDynamicLights;
            synchronized (dynamicLightsMap) {
                DynamicLights.updateMapDynamicLights(renderGlobal);
                if (mapDynamicLights.size() > 0) {
                    List<DynamicLight> list = mapDynamicLights.valueList();
                    for (int j2 = 0; j2 < list.size(); ++j2) {
                        DynamicLight dynamiclight = list.get(j2);
                        dynamiclight.update(renderGlobal);
                    }
                }
            }
        }
    }

    private static void initialize() {
        initialized = true;
        mapEntityLightLevels.clear();
        mapItemLightLevels.clear();
        String[] astring = ReflectorForge.getForgeModIds();
        for (int i2 = 0; i2 < astring.length; ++i2) {
            String s2 = astring[i2];
            try {
                jy resourcelocation = new jy(s2, "optifine/dynamic_lights.properties");
                InputStream inputstream = Config.getResourceStream(resourcelocation);
                DynamicLights.loadModConfiguration(inputstream, resourcelocation.toString(), s2);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (mapEntityLightLevels.size() > 0) {
            Config.dbg("DynamicLights entities: " + mapEntityLightLevels.size());
        }
        if (mapItemLightLevels.size() > 0) {
            Config.dbg("DynamicLights items: " + mapItemLightLevels.size());
        }
    }

    private static void loadModConfiguration(InputStream in2, String path, String modId) {
        if (in2 != null) {
            try {
                PropertiesOrdered properties = new PropertiesOrdered();
                properties.load(in2);
                in2.close();
                Config.dbg("DynamicLights: Parsing " + path);
                ConnectedParser connectedparser = new ConnectedParser("DynamicLights");
                DynamicLights.loadModLightLevels(properties.getProperty("entities"), mapEntityLightLevels, new EntityClassLocator(), connectedparser, path, modId);
                DynamicLights.loadModLightLevels(properties.getProperty("items"), mapItemLightLevels, new ItemLocator(), connectedparser, path, modId);
            }
            catch (IOException var5) {
                Config.warn("DynamicLights: Error reading " + path);
            }
        }
    }

    private static void loadModLightLevels(String prop, Map mapLightLevels, IObjectLocator ol2, ConnectedParser cp2, String path, String modId) {
        if (prop != null) {
            String[] astring = Config.tokenize(prop, " ");
            for (int i2 = 0; i2 < astring.length; ++i2) {
                String s2 = astring[i2];
                String[] astring1 = Config.tokenize(s2, ":");
                if (astring1.length != 2) {
                    cp2.warn("Invalid entry: " + s2 + ", in:" + path);
                    continue;
                }
                String s1 = astring1[0];
                String s22 = astring1[1];
                String s3 = modId + ":" + s1;
                jy resourcelocation = new jy(s3);
                Object object = ol2.getObject(resourcelocation);
                if (object == null) {
                    cp2.warn("Object not found: " + s3);
                    continue;
                }
                int j2 = cp2.parseInt(s22, -1);
                if (j2 >= 0 && j2 <= 15) {
                    mapLightLevels.put(object, new Integer(j2));
                    continue;
                }
                cp2.warn("Invalid light level: " + s2);
            }
        }
    }

    private static void updateMapDynamicLights(bfr renderGlobal) {
        bdb world = renderGlobal.getWorld();
        if (world != null) {
            for (pk entity : world.E()) {
                int i2 = DynamicLights.getLightLevel(entity);
                if (i2 > 0) {
                    int j2 = entity.F();
                    DynamicLight dynamiclight = mapDynamicLights.get(j2);
                    if (dynamiclight != null) continue;
                    dynamiclight = new DynamicLight(entity);
                    mapDynamicLights.put(j2, dynamiclight);
                    continue;
                }
                int k2 = entity.F();
                DynamicLight dynamiclight1 = mapDynamicLights.remove(k2);
                if (dynamiclight1 == null) continue;
                dynamiclight1.updateLitChunks(renderGlobal);
            }
        }
    }

    public static int getCombinedLight(cj pos, int combinedLight) {
        return DynamicLights.getCombinedLight(pos.n(), pos.o(), pos.p(), combinedLight);
    }

    public static int getCombinedLight(int x2, int y2, int z2, int combinedLight) {
        double d0 = DynamicLights.getLightLevel(x2, y2, z2);
        combinedLight = DynamicLights.getCombinedLight(d0, combinedLight);
        return combinedLight;
    }

    public static int getCombinedLight(pk entity, int combinedLight) {
        double d0 = DynamicLights.getLightLevel(entity);
        combinedLight = DynamicLights.getCombinedLight(d0, combinedLight);
        return combinedLight;
    }

    public static int getCombinedLight(double lightPlayer, int combinedLight) {
        int j2;
        int i2;
        if (lightPlayer > 0.0 && (i2 = (int)(lightPlayer * 16.0)) > (j2 = combinedLight & 0xFF)) {
            combinedLight &= 0xFFFFFF00;
            combinedLight |= i2;
        }
        return combinedLight;
    }

    public static double getLightLevel(cj pos) {
        return DynamicLights.getLightLevel(pos.n(), pos.o(), pos.p());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getLightLevel(int x2, int y2, int z2) {
        double d0 = 0.0;
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            List<DynamicLight> list = mapDynamicLights.valueList();
            int i2 = list.size();
            for (int j2 = 0; j2 < i2; ++j2) {
                double d8;
                double d9;
                double d10;
                DynamicLight dynamiclight = list.get(j2);
                int k2 = dynamiclight.getLastLightLevel();
                if (k2 <= 0) continue;
                double d1 = dynamiclight.getLastPosX();
                double d2 = dynamiclight.getLastPosY();
                double d3 = dynamiclight.getLastPosZ();
                double d4 = (double)x2 - d1;
                double d5 = (double)y2 - d2;
                double d6 = (double)z2 - d3;
                double d7 = d4 * d4 + d5 * d5 + d6 * d6;
                if (dynamiclight.isUnderwater() && !Config.isClearWater()) {
                    k2 = Config.limit(k2 - 2, 0, 15);
                    d7 *= 2.0;
                }
                if (!(d7 <= 56.25) || !((d10 = (d9 = 1.0 - (d8 = Math.sqrt(d7)) / 7.5) * (double)k2) > d0)) continue;
                d0 = d10;
            }
        }
        double d11 = Config.limit(d0, 0.0, 15.0);
        return d11;
    }

    public static int getLightLevel(zx itemStack) {
        yo itemblock;
        afh block;
        if (itemStack == null) {
            return 0;
        }
        zw item = itemStack.b();
        if (item instanceof yo && (block = (itemblock = (yo)item).d()) != null) {
            return block.r();
        }
        if (item == zy.ay) {
            return afi.l.r();
        }
        if (item != zy.bv && item != zy.bD) {
            Integer integer;
            if (item == zy.aT) {
                return 8;
            }
            if (item == zy.cD) {
                return 8;
            }
            if (item == zy.bE) {
                return 8;
            }
            if (item == zy.bZ) {
                return afi.bY.r() / 2;
            }
            if (!mapItemLightLevels.isEmpty() && (integer = mapItemLightLevels.get(item)) != null) {
                return integer;
            }
            return 0;
        }
        return 10;
    }

    public static int getLightLevel(pk entity) {
        vn entitycreeper;
        Integer integer;
        wn entityplayer;
        if (entity == Config.getMinecraft().ac() && !Config.isDynamicHandLight()) {
            return 0;
        }
        if (entity instanceof wn && (entityplayer = (wn)entity).v()) {
            return 0;
        }
        if (entity.at()) {
            return 15;
        }
        if (!mapEntityLightLevels.isEmpty() && (integer = mapEntityLightLevels.get(entity.getClass())) != null) {
            return integer;
        }
        if (entity instanceof ws) {
            return 15;
        }
        if (entity instanceof vj) {
            return 15;
        }
        if (entity instanceof vl) {
            vl entityblaze = (vl)entity;
            return entityblaze.n() ? 15 : 10;
        }
        if (entity instanceof vu) {
            vu entitymagmacube = (vu)entity;
            return (double)entitymagmacube.b > 0.6 ? 13 : 8;
        }
        if (entity instanceof vn && (double)(entitycreeper = (vn)entity).a(0.0f) > 0.001) {
            return 15;
        }
        if (entity instanceof pr) {
            pr entitylivingbase = (pr)entity;
            zx itemstack2 = entitylivingbase.bA();
            int i2 = DynamicLights.getLightLevel(itemstack2);
            zx itemstack1 = entitylivingbase.p(4);
            int j2 = DynamicLights.getLightLevel(itemstack1);
            return Math.max(i2, j2);
        }
        if (entity instanceof uz) {
            uz entityitem = (uz)entity;
            zx itemstack = DynamicLights.getItemStack(entityitem);
            return DynamicLights.getLightLevel(itemstack);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLights(bfr renderGlobal) {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            List<DynamicLight> list = mapDynamicLights.valueList();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                DynamicLight dynamiclight = list.get(i2);
                dynamiclight.updateLitChunks(renderGlobal);
            }
            mapDynamicLights.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            mapDynamicLights.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount() {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            return mapDynamicLights.size();
        }
    }

    public static zx getItemStack(uz entityItem) {
        zx itemstack = entityItem.H().f(10);
        return itemstack;
    }
}

