/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ReadOnlyByteBufferBuf;
import io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

final class ReadOnlyUnsafeDirectByteBuf
extends ReadOnlyByteBufferBuf {
    private static final boolean NATIVE_ORDER = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    private final long memoryAddress;

    public ReadOnlyUnsafeDirectByteBuf(ByteBufAllocator allocator, ByteBuffer buffer) {
        super(allocator, buffer);
        this.memoryAddress = PlatformDependent.directBufferAddress((ByteBuffer)buffer);
    }

    protected byte _getByte(int index) {
        return PlatformDependent.getByte((long)this.addr(index));
    }

    protected short _getShort(int index) {
        short v = PlatformDependent.getShort((long)this.addr(index));
        return NATIVE_ORDER ? v : Short.reverseBytes(v);
    }

    protected int _getUnsignedMedium(int index) {
        long addr = this.addr(index);
        return (PlatformDependent.getByte((long)addr) & 0xFF) << 16 | (PlatformDependent.getByte((long)(addr + 1L)) & 0xFF) << 8 | PlatformDependent.getByte((long)(addr + 2L)) & 0xFF;
    }

    protected int _getInt(int index) {
        int v = PlatformDependent.getInt((long)this.addr(index));
        return NATIVE_ORDER ? v : Integer.reverseBytes(v);
    }

    protected long _getLong(int index) {
        long v = PlatformDependent.getLong((long)this.addr(index));
        return NATIVE_ORDER ? v : Long.reverseBytes(v);
    }

    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.checkIndex(index, length);
        if (dst == null) {
            throw new NullPointerException("dst");
        }
        if (dstIndex < 0 || dstIndex > dst.capacity() - length) {
            throw new IndexOutOfBoundsException("dstIndex: " + dstIndex);
        }
        if (dst.hasMemoryAddress()) {
            PlatformDependent.copyMemory((long)this.addr(index), (long)(dst.memoryAddress() + (long)dstIndex), (long)length);
        } else if (dst.hasArray()) {
            PlatformDependent.copyMemory((long)this.addr(index), (byte[])dst.array(), (int)(dst.arrayOffset() + dstIndex), (long)length);
        } else {
            dst.setBytes(dstIndex, this, index, length);
        }
        return this;
    }

    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.checkIndex(index, length);
        if (dst == null) {
            throw new NullPointerException("dst");
        }
        if (dstIndex < 0 || dstIndex > dst.length - length) {
            throw new IndexOutOfBoundsException(String.format("dstIndex: %d, length: %d (expected: range(0, %d))", dstIndex, length, dst.length));
        }
        if (length != 0) {
            PlatformDependent.copyMemory((long)this.addr(index), (byte[])dst, (int)dstIndex, (long)length);
        }
        return this;
    }

    public ByteBuf getBytes(int index, ByteBuffer dst) {
        this.checkIndex(index);
        if (dst == null) {
            throw new NullPointerException("dst");
        }
        int bytesToCopy = Math.min(this.capacity() - index, dst.remaining());
        ByteBuffer tmpBuf = this.internalNioBuffer();
        tmpBuf.clear().position(index).limit(index + bytesToCopy);
        dst.put(tmpBuf);
        return this;
    }

    public ByteBuf copy(int index, int length) {
        this.checkIndex(index, length);
        UnpooledUnsafeDirectByteBuf copy = (UnpooledUnsafeDirectByteBuf)this.alloc().directBuffer(length, this.maxCapacity());
        if (length != 0) {
            PlatformDependent.copyMemory((long)this.addr(index), (long)copy.addr(0), (long)length);
            copy.setIndex(0, length);
        }
        return copy;
    }

    private long addr(int index) {
        return this.memoryAddress + (long)index;
    }
}

