/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.override;

import java.util.Arrays;
import net.optifine.DynamicLights;
import net.optifine.reflect.Reflector;
import net.optifine.util.ArrayCache;

public class ChunkCacheOF
implements adq {
    private final adv chunkCache;
    private final int posX;
    private final int posY;
    private final int posZ;
    private final int sizeX;
    private final int sizeY;
    private final int sizeZ;
    private final int sizeXY;
    private int[] combinedLights;
    private alz[] blockStates;
    private final int arraySize;
    private final boolean dynamicLights = Config.isDynamicLights();
    private static final ArrayCache cacheCombinedLights = new ArrayCache(Integer.TYPE, 16);
    private static final ArrayCache cacheBlockStates = new ArrayCache(alz.class, 16);

    public ChunkCacheOF(adv chunkCache, cj posFromIn, cj posToIn, int subIn) {
        this.chunkCache = chunkCache;
        int minChunkX = posFromIn.n() - subIn >> 4;
        int minChunkY = posFromIn.o() - subIn >> 4;
        int minChunkZ = posFromIn.p() - subIn >> 4;
        int maxChunkX = posToIn.n() + subIn >> 4;
        int maxChunkY = posToIn.o() + subIn >> 4;
        int maxChunkZ = posToIn.p() + subIn >> 4;
        this.sizeX = maxChunkX - minChunkX + 1 << 4;
        this.sizeY = maxChunkY - minChunkY + 1 << 4;
        this.sizeZ = maxChunkZ - minChunkZ + 1 << 4;
        this.sizeXY = this.sizeX * this.sizeY;
        this.arraySize = this.sizeX * this.sizeY * this.sizeZ;
        this.posX = minChunkX << 4;
        this.posY = minChunkY << 4;
        this.posZ = minChunkZ << 4;
    }

    private int getPositionIndex(cj pos) {
        int dx2 = pos.n() - this.posX;
        if (dx2 < 0 || dx2 >= this.sizeX) {
            return -1;
        }
        int dy2 = pos.o() - this.posY;
        if (dy2 < 0 || dy2 >= this.sizeY) {
            return -1;
        }
        int dz2 = pos.p() - this.posZ;
        if (dz2 < 0 || dz2 >= this.sizeZ) {
            return -1;
        }
        return dz2 * this.sizeXY + dy2 * this.sizeX + dx2;
    }

    @Override
    public int b(cj pos, int lightValue) {
        int index = this.getPositionIndex(pos);
        if (index < 0 || index >= this.arraySize || this.combinedLights == null) {
            return this.getCombinedLightRaw(pos, lightValue);
        }
        int light = this.combinedLights[index];
        if (light == -1) {
            this.combinedLights[index] = light = this.getCombinedLightRaw(pos, lightValue);
        }
        return light;
    }

    private int getCombinedLightRaw(cj pos, int lightValue) {
        int light = this.chunkCache.b(pos, lightValue);
        if (this.dynamicLights && !this.p(pos).c().c()) {
            light = DynamicLights.getCombinedLight(pos, light);
        }
        return light;
    }

    @Override
    public alz p(cj pos) {
        int index = this.getPositionIndex(pos);
        if (index < 0 || index >= this.arraySize || this.blockStates == null) {
            return this.chunkCache.p(pos);
        }
        alz iblockstate = this.blockStates[index];
        if (iblockstate == null) {
            this.blockStates[index] = iblockstate = this.chunkCache.p(pos);
        }
        return iblockstate;
    }

    public void renderStart() {
        if (this.combinedLights == null) {
            this.combinedLights = (int[])cacheCombinedLights.allocate(this.arraySize);
        }
        Arrays.fill(this.combinedLights, -1);
        if (this.blockStates == null) {
            this.blockStates = (alz[])cacheBlockStates.allocate(this.arraySize);
        }
        Arrays.fill(this.blockStates, null);
    }

    public void renderFinish() {
        cacheCombinedLights.free(this.combinedLights);
        this.combinedLights = null;
        cacheBlockStates.free(this.blockStates);
        this.blockStates = null;
    }

    @Override
    public boolean W() {
        return this.chunkCache.W();
    }

    @Override
    public ady b(cj pos) {
        return this.chunkCache.b(pos);
    }

    @Override
    public int a(cj pos, cq direction) {
        return this.chunkCache.a(pos, direction);
    }

    @Override
    public akw s(cj pos) {
        return this.chunkCache.s(pos);
    }

    @Override
    public adr G() {
        return this.chunkCache.G();
    }

    @Override
    public boolean d(cj pos) {
        return this.chunkCache.d(pos);
    }

    public boolean isSideSolid(cj pos, cq side, boolean _default) {
        return Reflector.callBoolean(this.chunkCache, Reflector.ForgeChunkCache_isSideSolid, pos, side, _default);
    }
}

