/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import java.util.ArrayList;
import net.optifine.entity.model.IEntityRenderer;

public abstract class ModelAdapter {
    private Class entityClass;
    private String name;
    private float shadowSize;
    private String[] aliases;

    public ModelAdapter(Class entityClass, String name, float shadowSize) {
        this.entityClass = entityClass;
        this.name = name;
        this.shadowSize = shadowSize;
    }

    public ModelAdapter(Class entityClass, String name, float shadowSize, String[] aliases) {
        this.entityClass = entityClass;
        this.name = name;
        this.shadowSize = shadowSize;
        this.aliases = aliases;
    }

    public Class getEntityClass() {
        return this.entityClass;
    }

    public String getName() {
        return this.name;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public float getShadowSize() {
        return this.shadowSize;
    }

    public abstract bbo makeModel();

    public abstract bct getModelRenderer(bbo var1, String var2);

    public abstract String[] getModelRendererNames();

    public abstract IEntityRenderer makeEntityRender(bbo var1, float var2);

    public bct[] getModelRenderers(bbo model) {
        String[] names = this.getModelRendererNames();
        ArrayList<bct> list = new ArrayList<bct>();
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            bct mr2 = this.getModelRenderer(model, name);
            if (mr2 == null) continue;
            list.add(mr2);
        }
        bct[] mrs = list.toArray(new bct[list.size()]);
        return mrs;
    }
}

