/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashMap;
import net.optifine.http.FileUploadThread;
import net.optifine.http.IFileUploadListener;
import net.optifine.shaders.Shaders;

public class CrashReporter {
    public static void onCrashReport(b crashReport, c category) {
        try {
            Throwable cause = crashReport.b();
            if (cause == null) {
                return;
            }
            if (cause.getClass().getName().contains(".fml.client.SplashProgress")) {
                return;
            }
            if (cause.getClass() == Throwable.class) {
                return;
            }
            CrashReporter.extendCrashReport(category);
            avh settings = Config.getGameSettings();
            if (settings == null) {
                return;
            }
            if (!settings.r) {
                return;
            }
            String url = "http://optifine.net/crashReport";
            String reportStr = CrashReporter.makeReport(crashReport);
            byte[] content = reportStr.getBytes("ASCII");
            IFileUploadListener listener = new IFileUploadListener(){

                @Override
                public void fileUploadFinished(String url, byte[] content, Throwable exception) {
                }
            };
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("OF-Version", Config.getVersion());
            headers.put("OF-Summary", CrashReporter.makeSummary(crashReport));
            FileUploadThread fut = new FileUploadThread(url, headers, content, listener);
            fut.setPriority(10);
            fut.start();
            Thread.sleep(1000L);
        }
        catch (Exception e2) {
            Config.dbg(e2.getClass().getName() + ": " + e2.getMessage());
        }
    }

    private static String makeReport(b crashReport) {
        StringBuffer sb2 = new StringBuffer();
        sb2.append("OptiFineVersion: " + Config.getVersion() + "\n");
        sb2.append("Summary: " + CrashReporter.makeSummary(crashReport) + "\n");
        sb2.append("\n");
        sb2.append(crashReport.e());
        sb2.append("\n");
        return sb2.toString();
    }

    private static String makeSummary(b crashReport) {
        Throwable t2 = crashReport.b();
        if (t2 == null) {
            return "Unknown";
        }
        StackTraceElement[] traces = t2.getStackTrace();
        String firstTrace = "unknown";
        if (traces.length > 0) {
            firstTrace = traces[0].toString().trim();
        }
        String sum = t2.getClass().getName() + ": " + t2.getMessage() + " (" + crashReport.a() + ")" + " [" + firstTrace + "]";
        return sum;
    }

    public static void extendCrashReport(c cat) {
        cat.a("OptiFine Version", Config.getVersion());
        cat.a("OptiFine Build", Config.getBuild());
        if (Config.getGameSettings() != null) {
            cat.a("Render Distance Chunks", "" + Config.getChunkViewDistance());
            cat.a("Mipmaps", "" + Config.getMipmapLevels());
            cat.a("Anisotropic Filtering", "" + Config.getAnisotropicFilterLevel());
            cat.a("Antialiasing", "" + Config.getAntialiasingLevel());
            cat.a("Multitexture", "" + Config.isMultiTexture());
        }
        cat.a("Shaders", "" + Shaders.getShaderPackName());
        cat.a("OpenGlVersion", "" + Config.openGlVersion);
        cat.a("OpenGlRenderer", "" + Config.openGlRenderer);
        cat.a("OpenGlVendor", "" + Config.openGlVendor);
        cat.a("CpuCount", "" + Config.getAvailableProcessors());
    }
}

