/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spi;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.spi.LoggerAdapter;
import org.apache.logging.log4j.spi.LoggerContext;
import org.apache.logging.log4j.util.LoaderUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLoggerAdapter<L>
implements LoggerAdapter<L> {
    protected final Map<LoggerContext, ConcurrentMap<String, L>> registry = new WeakHashMap<LoggerContext, ConcurrentMap<String, L>>();

    @Override
    public L getLogger(String name) {
        LoggerContext context = this.getContext();
        ConcurrentMap<String, L> loggers = this.getLoggersInContext(context);
        if (loggers.containsKey(name)) {
            return (L)loggers.get(name);
        }
        loggers.putIfAbsent(name, this.newLogger(name, context));
        return (L)loggers.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentMap<String, L> getLoggersInContext(LoggerContext context) {
        Map<LoggerContext, ConcurrentMap<String, L>> map = this.registry;
        synchronized (map) {
            ConcurrentMap<String, L> loggers = this.registry.get(context);
            if (loggers == null) {
                loggers = new ConcurrentHashMap<String, L>();
                this.registry.put(context, loggers);
            }
            return loggers;
        }
    }

    protected abstract L newLogger(String var1, LoggerContext var2);

    protected abstract LoggerContext getContext();

    protected LoggerContext getContext(Class<?> callerClass) {
        ClassLoader cl = null;
        if (callerClass != null) {
            cl = callerClass.getClassLoader();
        }
        if (cl == null) {
            cl = LoaderUtil.getThreadContextClassLoader();
        }
        return LogManager.getContext(cl, false);
    }

    @Override
    public void close() {
        this.registry.clear();
    }
}

